/* -*- mode: C; comment-column: 40; fill-column: 79 -*- */
/* $Id: sema.h,v 1.125 1999/10/04 23:42:32 donwm Exp $ */
/* Copyright (C) 1994 - 1998, Hewlett-Packard Company, all rights reserved. */
/* Taken from E1431 library, heavily modified by Eric Backus */

/* This is the header file for the hardware driver for the E1432 VXI
   module.  It contains the defines and typedefs internal to the
   driver code. */

#ifndef _E1432_SEMA_H
#define _E1432_SEMA_H

/* ******** Defines ******** */

#ifdef	HPVXI_DOWNLOAD
#define volatile	/* apparently no volatile in HPVXI_DOWNLOAD */
#endif

#if defined(HAVE_VTL)
#ifdef HAVE_SICL
#undef HAVE_SICL
#endif
#define INST unsigned long
/* modify sicl names to avoid linker confusion */
#define ilblockcopy nq_ilblockcopy
#define iwblockcopy nq_iwblockcopy
#define iwpushfifo nq_iwpushfifo
#define ibeswap nq_ibeswap
#else /* !HAVE_VTL */

#if defined(_HPUX_SOURCE) || defined(_WINDLL) || defined(E1485_SOURCE)
#define	HAVE_SICL
#define	E1432_SICL_TIMEOUT	10000	/* 10 seconds */
#define	E1432_SICL_ID_MAX	30	/* Max SICL sessions */
#endif

#endif /* !HAVE_VTL */

#if defined(MSDOS) || defined(_MSDOS) || defined(__MSDOS) ||\
    defined(__MSDOS__) || defined(_WINDOWS) || defined(__WINDOWS) ||\
    defined(_WIN32) || defined(WIN32)
#define	MICROSOFT_OS
#endif

/* EMULATE_SICL picks up the 16 bit Production Test VB application */
#if defined(E1485_SOURCE) || defined(EMULATE_SICL)
#define	NO_D32
#endif

#if !(defined MICROSOFT_OS || defined HPVXI_DOWNLOAD)
#define	HAVE_SIGBUS
#endif

#if defined(M_I86) || defined(_M_I86) || defined(__M_I86) || defined(__M_I86__) ||\
       defined(_WIN32)
#define	SWAP	1
#else
#define	SWAP	0
#endif

/* ******** Includes ******** */

#if defined(_HPUX_SOURCE) || defined(_WINDLL) || defined(_WIN32)
#include <stdio.h>
#include <stdlib.h>
#include <string.h>			/* in error.c */
#include <ctype.h>			/* in machine.c */
#include <math.h>			/* in filter.c, trigger.c */
#include <signal.h>			/* in io.c, machine.c */
#include <setjmp.h>			/* in sema.h, io.c */
#include <time.h>			/* in many files */

#ifdef	MALLOC_TRACE
#include <malloc.h>			/* Debug/trace malloc */
#endif

/* sicl includes */
#ifdef HAVE_SICL
#ifdef EMULATE_SICL
#include <esicl.h>  /* emulated A24 sicl */
#else
#include <sicl.h>
#endif
#endif

/* Window include */
#if defined( _WINDLL) || defined(_WIN32)
#include <windows.h>
#endif
#endif

/* E1485 (Godzilla) include */
#ifdef E1485_SOURCE
#include "/opt/e1485/include/spil_d.h"	/* includes stdc_d.h */
#endif

#include "err1432.h"
#include "e1432.h"
#include "e1432i.h"

/* E1406 VXI commander module */
#ifdef	HPVXI_DOWNLOAD
#ifndef _SIZE_T
#define _SIZE_T
#ifndef _STDDEF_INCLUDED_  /* /usr/hp64000/68000/include/stddef.h */
typedef unsigned int size_t;
#endif  /* _STDDEF_INCLUDED */
#endif  /* _SIZE_T */
#ifndef POS_A24_HANDLE
#define POS_A24_HANDLE unsigned long
#endif  /* POS_A24_HANDLE */
#endif  /* HPVXI_DOWNLOAD */

/* ******** Workaround allocation, printf, and sicl ******** */

#ifdef	HPVXI_DOWNLOAD
#define	free(_x)		os_mem_free(_x)
#define	malloc(_x)		os_mem_alloc(_x)
#endif

#if defined(_HPUX_SOURCE) || defined(E1485_SOURCE) || defined(MICROSOFT_OS) \
  || defined(HPVXI_DOWNLOAD)

#define	ALLOW_PRINTF
/* Note that _s must itself contain surrounding parentheses */
#define	PRINTF(_s)		(void) printf _s

/* output when running diagnostic code */
#define DIAG_PRINTF(_n, _s)	\
{ if ( i1432_diag_print_level > (_n) ) (void) printf _s; }

#ifdef	HPVXI_DOWNLOAD
#define DIAG_Q_ERR(_e_) i1432_diag_que_err(_e_) /* xlate, put in error queue */
#else	/* HPVXI_DOWNLOAD */
#define DIAG_Q_ERR(_e_)	_e_			/* nop */
#endif	/* HPVXI_DOWNLOAD */

#define DIAG_ERR_INPUT_SCA(_x_)	(ERR1432_DIAG_ERR_INPUT_SCA0 - (_x_))


#ifdef	__lint
#define	TRACE_PRINTF(_n, _s)	\
do { if (i1432_trace_level > (_n)) (void) printf _s; }\
while (i1432_trace_level)
#else
#define	TRACE_PRINTF(_n, _s)	\
do { if (i1432_trace_level > (_n)) (void) printf _s; } while (0)
#endif

#ifdef _WINDLL
/*  printf() is normally not available in a DLL.   */
int __cdecl printf(const char *a, ...);
#endif

#else	/* !_HPUX_SOURCE && !E1485_SOURCE */

#define	PRINTF(_s)		/* No op */
#define	TRACE_PRINTF(_n, _s)	/* No op */
#define DIAG_PRINTF(_n, _s)	/* No op */

#endif	/* !_HPUX_SOURCE && !E1485_SOURCE */

/* workaround lseek offset type, off_t, missing from some Windows io.h */
#ifndef off_t 
#define off_t long
#endif

/* ******** Misc ******** */

/* VXI Device TYPe register */
#define	DTYPE_MODEL_CODE_MASK	0x0fff
#define	DTYPE_A24_MASK		0xf000

/* Real HW FIFO */
#define	FIFO_PAGE_START_1M	2
#define	FIFO_PAGE_START_256K	1
#define	FIFO_PAGE_NUM		1

typedef struct e1432_module_list_node
{
    SHORTSIZ16 flag;			/* general purpose flag */

    /* General info */
    E1432ID hw;				/* (currently unused) hw pointer */
    SHORTSIZ16 la;			/* Logical address */
    SHORTSIZ16 chan_id;			/* Channel ID in module */
    int     a24_256k;			/* Does have 256K A24 mod? */
    int     nchan;			/* Number of channels */
    int     input_chans;		/* Number of input channels */
    int     d32;			/* Use d32 to access module */
#if defined(HAVE_SICL) || defined(HAVE_VTL)
    INST    sicl_id;			/* SICL ID */
#endif
#ifdef	HAVE_SICL
    int     a24_id_index;		/* Index for a24 sicl session */
    int     a24_fifo_id_index;		/* Index for a24 fifo sicl session */
    int     a24_fifo_map_space;		/* Map space for fifo */
    unsigned int a24_pagestart;		/* First A24 page for this module */
    unsigned int a24_pagecnt;		/* A24 pages mapped (non fifo) */
    unsigned int a24_fifo_pagestart;	/* First fifo page for this module */
    int     a24_imap_count;		/* Which imap the A24 map is */
    int     a24_fifo_imap_count;	/* Which imap the FIFO map is */
#endif
#if defined(INSTR_CALLBACKS) && defined(HAVE_VTL)
    void (*cbFunc)();			/* callback func for this module */
    LONGSIZ32 cbValue; 			/* callback value for this module  */
    LONGSIZ32 cbHandle; 		/* callback handle for this module  */
#endif
    SHORTSIZ16 *a16_base;		/* Base of A16 address space */
    LONGSIZ32 *a24_base;		/* Base of A24 address space */
    LONGSIZ32 *a24_fifo_base;		/* Base of A24 fifo address space */
#ifdef HPVXI_DOWNLOAD
    POS_A24_HANDLE *pos_a24_handle;     /* returned by os_setup_a24() */
#endif

    /* Used for request spectrum */
    LONGSIZ32 rs_bsize;			/* Request blocksize */
    LONGSIZ32 rs_navg;			/* Request number of averages */
    FLOATSIZ32 rs_span;			/* Request span */
    int rs_magsq;			/* Request mag squared */
    int rs_ready;			/* Request ready */
    int rs_req;				/* Request count */
    int rs_irq_done;			/* Request irq done */
    int rs_irq_error;			/* Request irq error */
    SHORTSIZ16 rs_irq_id;		/* Request irq ID */
    int rs_irq_off;			/* Request irq interrupts blocked */
    SHORTSIZ16 rs_irq_save_line;	/* Request irq save line */
    SHORTSIZ16 rs_irq_save_mask;	/* Request irq save mask */
#ifdef	HAVE_SICL
    INST rs_irq_sicl_id;		/* Request irq SICL id */
#endif

    /* Analog */
    SHORTSIZ16 wasACsettled[E1432_CHANS]; /* did settle last time? */

    /* Timing */
    SHORTSIZ16 autoGroup;		/* E1432_AUTO_GROUP_MEAS_ON, _OFF */

    /* Cache these to decrease data transfer overhead */
    LONGSIZ32 blocksize;
    SHORTSIZ16 append_status;
    SHORTSIZ16 data_size;
    SHORTSIZ16 meas_type;
    int     freq_mag_squared;
    int     zoom;
    int     order_tracking;
    int     rpm_arm;
}
E1432_MODULE_LIST_NODE;

/* Channel structure */
typedef struct e1432_chan_list_node
{
    struct e1432_chan_list_node *next;	/* link to next */
    SHORTSIZ16 chanID;
}
E1432_CHAN_LIST_NODE;

/* Group structure */
typedef struct e1432_group_list_node
{
    struct e1432_group_list_node *next;	/* Link to next */
    E1432_CHAN_LIST_NODE *chanlist;	/* List of channels */
    int modcount;			/* How many modules */
    E1432_MODULE_LIST_NODE **modlist;	/* Array of modules */
    SHORTSIZ16 groupID;			/* Group ID */
    E1432_MODULE_LIST_NODE *system_mod;	/* System module */
    E1432_MODULE_LIST_NODE *trigmn;	/* trigger module */
    int     otra;			/* Order track or RPM arm */
}
E1432_GROUP_LIST_NODE;

struct i1432_chan_info
{
    E1432_MODULE_LIST_NODE *mn;
    int index;				/* Index within module */
    int sca;				/* Sca number within module */

    /* This could possibly go in the module_list_node instead of here.  But
       putting it here allows for some future module that has more than one
       type of input channel installed in it.  This is the SCA id, which is
       used by parms.c for e1432_get_current_value. */
    int     sca_id;

    /* A parameter kept in the host rather than the module?  This might not be
       a good idea, but it's convenient since the auto range is done in the
       host rather than the module. */
    SHORTSIZ16 auto_range_mode;

    /* ID of other channel in SCA, zero if none.  Used by srcdata.c. */
    SHORTSIZ16 other_chan;

    /* Cache these to decrease data transfer overhead */
    SHORTSIZ16 active, calc_data;
    FLOATSIZ64 scale;
};

#ifdef	HAVE_SICL
struct i1432_iopen_list_info
{
    char   *name;			/* SICL interface name */
    INST    id[E1432_SICL_ID_MAX];	/* Array of SICL ids */
    int     avail[E1432_SICL_ID_MAX];	/* Array of avail flags */
    int     nid;			/* Valid entries in id/avail arrays */
};
#endif

#ifndef	HPVXI_DOWNLOAD
# include "global.h"
#else
# ifdef	END_TOKEN	/* From stream.h */
#  include "global.h"
# else
#  include "exec_rtn.h"	/* Includes global.h along with SCPI related headers */
# endif
#endif

/* ******** Internal Functions ******** */

/* sca.c */
extern SHORTSIZ16
i1432_sca_dsp_download_mod(E1432ID, SHORTSIZ16, LONGSIZ32, LONGSIZ32 *);
extern SHORTSIZ16
i1432_sca_dsp_download_chan(E1432ID, SHORTSIZ16, LONGSIZ32, LONGSIZ32 *);

/* decompress.c */
extern int i1432_decompress(char *, unsigned long, int *);
extern int i1432_decompress_init(char *, int **, unsigned long);

/* diagnostics */
extern SHORTSIZ16
i1432_test_vxi(E1432_MODULE_LIST_NODE *);
extern SHORTSIZ16
i1432_test_asram(E1432_MODULE_LIST_NODE *);
extern SHORTSIZ16
i1432_test_bsram(E1432_MODULE_LIST_NODE *);
extern SHORTSIZ16
i1432_test_dram(E1432_MODULE_LIST_NODE *, SHORTSIZ16 *);
extern SHORTSIZ16
i1432_test_flash(E1432_MODULE_LIST_NODE *);
extern SHORTSIZ16
i1432_test_vxi_dsp(E1432_MODULE_LIST_NODE *);
extern SHORTSIZ16
i1432_test_96k_hostport(E1432_MODULE_LIST_NODE *);
extern SHORTSIZ16
i1432_test_pll(E1432_MODULE_LIST_NODE *);
extern SHORTSIZ16
i1432_check_sca(E1432_MODULE_LIST_NODE *, SHORTSIZ16, SHORTSIZ16 *);
extern SHORTSIZ16
i1432_test_vibrato(E1432_MODULE_LIST_NODE *, SHORTSIZ16);
extern SHORTSIZ16
i1432_test_sonata_a(E1432_MODULE_LIST_NODE *, SHORTSIZ16);
extern SHORTSIZ16
i1432_test_sonata_b(E1432_MODULE_LIST_NODE *, SHORTSIZ16);
extern SHORTSIZ16
i1432_test_tach(E1432_MODULE_LIST_NODE *);
extern void
i1432_print_acc_fail(int, SHORTSIZ16, char *);
extern void
i1432_r32(E1432_MODULE_LIST_NODE *, SHORTSIZ16 *, LONGSIZ32, LONGSIZ32 *);
extern void
i1432_r32u(E1432_MODULE_LIST_NODE *, SHORTSIZ16 *, LONGSIZ32, ULONGSIZ32 *);
extern void
i1432_w32(E1432_MODULE_LIST_NODE *, SHORTSIZ16 *, LONGSIZ32, LONGSIZ32);
extern void
i1432_berr_recover(E1432_MODULE_LIST_NODE *);
extern void
i1432_reset_module(E1432_MODULE_LIST_NODE *);
#ifdef	HPVXI_DOWNLOAD
extern SHORTSIZ16
i1432_diag_que_err(SHORTSIZ16);
#endif

/* error.c */
extern SHORTSIZ16 i1432_la_print_error(SHORTSIZ16, SHORTSIZ16);
extern SHORTSIZ16 i1432_id_print_error(E1432ID, SHORTSIZ16, SHORTSIZ16);
extern SHORTSIZ16 i1432_print_error(SHORTSIZ16);
extern char *i1432_get_error_string(SHORTSIZ16);

/* getdata.c */
extern SHORTSIZ16 i1432_reset_spectrum(E1432ID, SHORTSIZ16);

/* install.c */
extern SHORTSIZ16 i1432_open_file(const char *path, int *file_des,
				  off_t *file_size);
#ifdef	HAVE_VTL
extern void i1432_set_error_info(char *);
#endif

/* io.c */
extern SHORTSIZ16 i1432_introff(void);
extern SHORTSIZ16 i1432_intron(void);
extern SHORTSIZ16 i1432_buserr_report(SHORTSIZ16, long, char *);
extern void i1432_buserr_handler(LONGSIZ32 sig, LONGSIZ32 code,
				 struct sigcontext *scp);
extern SHORTSIZ16 i1432_wait_bits_match(E1432_MODULE_LIST_NODE *mn,
					LONGSIZ32 reg,
					SHORTSIZ16 bitMask,
					SHORTSIZ16 bitState,
					FLOATSIZ64 timeout, char *errorStr);
extern SHORTSIZ16 i1432_wait32_bits_match(E1432_MODULE_LIST_NODE *mn,
					  LONGSIZ32 reg,
					  LONGSIZ32 bitMask,
					  LONGSIZ32 bitState,
					  FLOATSIZ64 timeout, char *errorStr);
extern SHORTSIZ16 i1432_error_wait32_bits_match(E1432_MODULE_LIST_NODE *mn,
						LONGSIZ32 reg,
						LONGSIZ32 bitMask,
						LONGSIZ32 bitState,
						FLOATSIZ64 timeout,
						char *errorStr);
extern SHORTSIZ16 i1432_error_wait32_bits_no_match(E1432_MODULE_LIST_NODE *mn,
						   LONGSIZ32 reg,
						   LONGSIZ32 bitMask,
						   LONGSIZ32 bitState,
						   FLOATSIZ64 timeout,
						   char *errorStr);
extern SHORTSIZ16 i1432_error_check(E1432ID, SHORTSIZ16 ID);
extern SHORTSIZ16 i1432_read_resp(E1432ID, SHORTSIZ16 ID, LONGSIZ32 *resp);
extern SHORTSIZ16 i1432_read_resp4(E1432ID, SHORTSIZ16 ID, LONGSIZ32 *resp1,
				   LONGSIZ32 *resp2, LONGSIZ32 *resp3,
				   LONGSIZ32 *resp4);
extern SHORTSIZ16 i1432_write_cmd_finish(E1432ID, SHORTSIZ16 ID, LONGSIZ32 cmd);
extern SHORTSIZ16 i1432_write_cmd0(E1432ID, SHORTSIZ16 ID, LONGSIZ32 cmd);
extern SHORTSIZ16 i1432_write_cmd1(E1432ID, SHORTSIZ16 ID, LONGSIZ32 cmd,
				   LONGSIZ32 parm1);
extern SHORTSIZ16 i1432_write_cmd1_start(E1432ID, SHORTSIZ16 ID, LONGSIZ32 cmd,
				   LONGSIZ32 parm1);
extern SHORTSIZ16 i1432_write_cmd2(E1432ID, SHORTSIZ16 ID, LONGSIZ32 cmd,
				   LONGSIZ32 parm1, LONGSIZ32 parm2);
extern SHORTSIZ16 i1432_write_cmd3(E1432ID, SHORTSIZ16, LONGSIZ32,
				   LONGSIZ32, LONGSIZ32, LONGSIZ32);
extern SHORTSIZ16 i1432_write_cmd4(E1432ID, SHORTSIZ16, LONGSIZ32,
				   LONGSIZ32, LONGSIZ32, LONGSIZ32, LONGSIZ32);
extern SHORTSIZ16 i1432_direct_write_register(E1432_MODULE_LIST_NODE *mn,
					      LONGSIZ32 reg, SHORTSIZ16 data);
extern SHORTSIZ16 i1432_direct_read_register(E1432_MODULE_LIST_NODE *mn,
					     LONGSIZ32 reg, SHORTSIZ16 *data);
extern SHORTSIZ16 i1432_direct_write32_register(E1432_MODULE_LIST_NODE *mn,
						LONGSIZ32 reg,
						LONGSIZ32 data);
extern SHORTSIZ16 i1432_direct_write32_register_a(E1432_MODULE_LIST_NODE *mn,
						  LONGSIZ32 reg,
						  int a24,
						  LONGSIZ32 data);
extern SHORTSIZ16 i1432_direct_read32_register(E1432_MODULE_LIST_NODE *mn,
					       LONGSIZ32 reg,
					       LONGSIZ32 *data);
extern SHORTSIZ16 i1432_direct_read32_register_a(E1432_MODULE_LIST_NODE *mn,
					         LONGSIZ32 reg,
						 int a24,
					         LONGSIZ32 *data);
extern SHORTSIZ16 i1432_direct_ping_register(E1432_MODULE_LIST_NODE *,
					     LONGSIZ32);
extern SHORTSIZ16 i1432_calc_register_address(E1432_MODULE_LIST_NODE *,
					      LONGSIZ32,
					      volatile SHORTSIZ16 **);
extern SHORTSIZ16 i1432_calc_register_address_a(E1432_MODULE_LIST_NODE *,
						LONGSIZ32, int,
						volatile SHORTSIZ16 **);
extern SHORTSIZ16 i1432_imap(E1432_MODULE_LIST_NODE *, int);
extern SHORTSIZ16 i1432_iunmap(E1432_MODULE_LIST_NODE *, int);
extern SHORTSIZ16 i1432_xfer_block(E1432_MODULE_LIST_NODE *,
				   unsigned long *, unsigned long *,
				   unsigned long, int, int);
extern SHORTSIZ16 i1432_data_handshake(E1432_MODULE_LIST_NODE *);
#if SWAP
extern SHORTSIZ16 i1432_two_four_swap(char *, long);
#endif

/* machine.c */
extern void i1432_get_time(FLOATSIZ64 * secs);
extern void i1432_pause(FLOATSIZ64 delay);
extern SHORTSIZ16 i1432_sema_present(E1432_MODULE_LIST_NODE *mn);

/* meas.c */
extern SHORTSIZ16 i1432_sync_system(E1432ID, SHORTSIZ16 ID);
extern SHORTSIZ16 i1432_unmap_one_fifo(E1432_MODULE_LIST_NODE *);

/* modgroup.c */
extern SHORTSIZ16 i1432_reset(E1432_MODULE_LIST_NODE *);
extern SHORTSIZ16 i1432_wait_reset(E1432_MODULE_LIST_NODE *);

extern SHORTSIZ16 i1432_sicl_setup1(E1432_MODULE_LIST_NODE *, int, int);
extern SHORTSIZ16 i1432_sicl_setup2(E1432_MODULE_LIST_NODE *);
extern SHORTSIZ16 i1432_sicl_cleanup(E1432_MODULE_LIST_NODE *);
extern SHORTSIZ16 i1432_fake_setup_sicl(E1432_MODULE_LIST_NODE *, SHORTSIZ16,
					struct i1432_chan_info *, int);
extern SHORTSIZ16 i1432_fake_cleanup_sicl(E1432_MODULE_LIST_NODE *,
					  struct i1432_chan_info *, int);
extern E1432_GROUP_LIST_NODE *i1432_get_group_node(E1432ID, SHORTSIZ16);
extern SHORTSIZ16 i1432_get_module_from_chan(E1432ID, SHORTSIZ16,
					     E1432_MODULE_LIST_NODE **);
extern SHORTSIZ16 i1432_get_chan_from_module(E1432_MODULE_LIST_NODE *);
extern int i1432_get_chan_index(E1432ID, SHORTSIZ16);
extern SHORTSIZ16 i1432_get_chan_other(E1432ID, SHORTSIZ16);
extern int i1432_get_chan_sca(E1432ID, SHORTSIZ16);
extern int i1432_get_chan_sca_id(E1432ID, SHORTSIZ16);
extern int i1432_get_id_nchan(E1432ID, SHORTSIZ16, int *);
extern SHORTSIZ16 i1432_get_system_module(E1432ID, SHORTSIZ16,
					  E1432_MODULE_LIST_NODE **);
extern SHORTSIZ16 i1432_checkID(E1432ID, SHORTSIZ16);
extern SHORTSIZ16 i1432_assign_system_module(E1432ID, SHORTSIZ16);
extern LONGSIZ32 i1432_get_sicl_id();

/* octave.c */
extern SHORTSIZ16 i1432_octave_download(E1432ID, SHORTSIZ16);
extern SHORTSIZ16 i1432_octave_configure(E1432ID, SHORTSIZ16, SHORTSIZ16);

/* options.c */
extern SHORTSIZ16 i1432_sca_type(int, char *);
extern SHORTSIZ16 i1432_dram_size(char *);

/* set.c */
extern SHORTSIZ16 i1432_get_chan_float(E1432ID, SHORTSIZ16 ID, LONGSIZ32 reg,
				       FLOATSIZ32 * ptr);
extern SHORTSIZ16 i1432_get_chan_long(E1432ID, SHORTSIZ16 ID, LONGSIZ32 reg,
				      LONGSIZ32 * ptr);
extern SHORTSIZ16 i1432_get_chan_short(E1432ID, SHORTSIZ16 ID, LONGSIZ32 reg,
				       SHORTSIZ16 * ptr);
extern SHORTSIZ16 i1432_get_chan_limits(E1432ID, SHORTSIZ16 ID, LONGSIZ32 cmd,
					FLOATSIZ32 *min, FLOATSIZ32 *max,
					FLOATSIZ32 *def, FLOATSIZ32 *step);
extern SHORTSIZ16 i1432_set_chan(E1432ID, SHORTSIZ16 ID, LONGSIZ32 reg,
				 LONGSIZ32 cmd, LONGSIZ32 value);
extern SHORTSIZ16 i1432_get_mod_float(E1432ID, SHORTSIZ16 ID, LONGSIZ32 reg,
				      FLOATSIZ32 *ptr);
extern SHORTSIZ16 i1432_get_mod_long(E1432ID, SHORTSIZ16 ID, LONGSIZ32 reg,
				     LONGSIZ32 *ptr);
extern SHORTSIZ16 i1432_get_mod_short(E1432ID, SHORTSIZ16 ID, LONGSIZ32 reg,
				      SHORTSIZ16 *ptr);
extern SHORTSIZ16 i1432_get_mod_limits(E1432ID, SHORTSIZ16 ID, LONGSIZ32 cmd,
				       FLOATSIZ32 *min, FLOATSIZ32 *max,
				       FLOATSIZ32 *def, FLOATSIZ32 *step);
extern SHORTSIZ16 i1432_set_mod(E1432ID, SHORTSIZ16 ID, LONGSIZ32 reg,
				LONGSIZ32 cmd, LONGSIZ32 value);
extern SHORTSIZ16 i1432_set_mod_nowait(E1432ID, SHORTSIZ16 ID, LONGSIZ32 reg,
				LONGSIZ32 cmd, LONGSIZ32 value);

/* siclimap.c */
#ifdef	HAVE_SICL
extern SHORTSIZ16 i1432_sicl_imap_init(void);
extern SHORTSIZ16 i1432_sicl_imap_uninit(void);
extern SHORTSIZ16 i1432_sicl_imap_setup(E1432_MODULE_LIST_NODE *, int);
extern SHORTSIZ16 i1432_sicl_imap_setup2(E1432_MODULE_LIST_NODE *);
extern SHORTSIZ16 i1432_sicl_imap(E1432_MODULE_LIST_NODE *, int);
extern SHORTSIZ16 i1432_sicl_iunmap(E1432_MODULE_LIST_NODE *, int);
#endif

/* srcdata.c */
extern SHORTSIZ16 i1432_xfer_writedata(E1432_MODULE_LIST_NODE *, LONGSIZ32 *,
				       LONGSIZ32, LONGSIZ32);

/* vtlio.c */
#ifdef HAVE_VTL /* these are defined in vtlio.c only if HAVE_VTL defined */

extern SHORTSIZ16 i1432_visa_introff(void);
extern SHORTSIZ16 i1432_visa_intron(void);
extern SHORTSIZ16 i1432_module_connect(E1432_MODULE_LIST_NODE *mn);
extern SHORTSIZ16 i1432_visa_get_lock_mode(int *);
extern SHORTSIZ16 i1432_visa_set_lock_mode(int);

extern SHORTSIZ16 i1432_visa_setup(E1432_MODULE_LIST_NODE *mn);

extern SHORTSIZ16 i1432_visa_cleanup(E1432_MODULE_LIST_NODE *mn);

extern SHORTSIZ16 i1432_vtl_mod_setup (E1432_MODULE_LIST_NODE *mn, int use_fifo,
                                      int big_map, int extra_io);

extern int ibeswap(char *addr,unsigned long length,int datasize);

extern int iwblockcopy(INST id, unsigned short *src, unsigned short  *dest,
                         unsigned long cnt, int swap);

extern int iwblockcopyout(INST id, unsigned short *src, unsigned short  *dest,
                         unsigned long cnt, int swap);

extern int ilblockcopy(INST id, unsigned long  *src, unsigned long   *dest,
                         unsigned long cnt, int swap);

extern int ilblockcopyout(INST id, unsigned long  *src, unsigned long   *dest,
                         unsigned long cnt, int swap);

extern int iwpushfifo(INST id, unsigned short *src,unsigned short *fifo,
                      unsigned long cnt, int swap);

extern int i1432_find_modules(LONGSIZ32 *LAlist,LONGSIZ32 listSize,
		       LONGSIZ32 *numFound,
		       char *rsrc,LONGSIZ32 rsrcLen);

#if (defined(INSTR_CALLBACKS)&&defined(HAVE_VTL))
extern LONGSIZ32 vtl_install_callback  (LONGSIZ32 vi, LONGSIZ32 channel,
			  void (*cbf)(), LONGSIZ32 mask);

extern LONGSIZ32 vtl_remove_callbacks(void);

#endif

#endif

/* zap.c */
extern SHORTSIZ16
i1432_map_sca(E1432_MODULE_LIST_NODE *, SHORTSIZ16, LONGSIZ32 *);
extern SHORTSIZ16 
i1432_wait_src_sisr_cmdack(E1432_MODULE_LIST_NODE *, LONGSIZ32, char *);
extern SHORTSIZ16 
i1432_write_ack_src_hp_cmd(E1432_MODULE_LIST_NODE *, LONGSIZ32, LONGSIZ32);
extern SHORTSIZ16 
i1432_write_nack_src_hp_cmd(E1432_MODULE_LIST_NODE *, LONGSIZ32, LONGSIZ32);
extern SHORTSIZ16 
i1432_read_src_hp_data(E1432_MODULE_LIST_NODE *,  LONGSIZ32, LONGSIZ32 *);
extern SHORTSIZ16 
i1432_write_src_hp_data(E1432_MODULE_LIST_NODE *, LONGSIZ32, LONGSIZ32);
extern SHORTSIZ16
i1432_read_src_hp_block(E1432_MODULE_LIST_NODE *, LONGSIZ32, LONGSIZ32,
                        LONGSIZ32 *);
extern SHORTSIZ16
i1432_write_src_hp_block(E1432_MODULE_LIST_NODE *, LONGSIZ32, LONGSIZ32,
			 LONGSIZ32 *);
extern SHORTSIZ16
i1432_blkwrite_src(E1432_MODULE_LIST_NODE *, LONGSIZ32, LONGSIZ32, LONGSIZ32 *,
		   LONGSIZ32, LONGSIZ32);
extern SHORTSIZ16
i1432_src_ok(E1432_MODULE_LIST_NODE *, LONGSIZ32);
extern SHORTSIZ16
i1432_write_serial(SHORTSIZ16 la, char *serial);
extern SHORTSIZ16
i1432_is_sonata_b(SHORTSIZ16 la, SHORTSIZ16 sca);
extern SHORTSIZ16
i1432_download_sca_ee_io(SHORTSIZ16 la, SHORTSIZ16 sca);
extern SHORTSIZ16
i1432_read_sca_eeprom_block(SHORTSIZ16 la, SHORTSIZ16 sca, LONGSIZ32 addr,
  LONGSIZ32 length, LONGSIZ32 *data);
extern SHORTSIZ16
i1432_read_sca_eeprom(SHORTSIZ16 la, SHORTSIZ16 sca, LONGSIZ32 addr,
  LONGSIZ32 *data);
extern SHORTSIZ16
i1432_write_sca_eeprom_block(SHORTSIZ16 la, SHORTSIZ16 sca, LONGSIZ32 addr,
  LONGSIZ32 length, LONGSIZ32 *data);
extern SHORTSIZ16
i1432_write_sca_eeprom(SHORTSIZ16 la, SHORTSIZ16 sca, LONGSIZ32 addr,
  LONGSIZ32 data);


#if defined(HAVE_VTL) && defined(WIN32) && !defined(WANT_PRINTF)
extern void flog(char *); 
extern int flogprintf(char *,...);

#ifdef printf
#undef printf
#endif
#define printf flogprintf

#endif	/* HAVE_VTL, WIN32, !WANT_PRINTF */

#endif /* _E1432_SEMA_H */
